/*
 * Decompiled with CFR 0.152.
 */
package DE.siemens.ad.pdraw.action;

import CH.ifa.draw.framework.Figure;
import DE.siemens.ad.logo.app.Application;
import DE.siemens.ad.logo.app.action.ActionManager;
import DE.siemens.ad.logo.app.action.LogoAction;
import DE.siemens.ad.logo.model.Block;
import DE.siemens.ad.logo.model.BlockConnector;
import DE.siemens.ad.logo.model.InBlockConnector;
import DE.siemens.ad.logo.model.InBlockConnectorEnumeration;
import DE.siemens.ad.logo.model.OutBlockConnector;
import DE.siemens.ad.logo.model.block.DeputyBlock;
import DE.siemens.ad.logo.util.Global;
import DE.siemens.ad.logo.util.Language;
import DE.siemens.ad.logo.util.ProgramException;
import DE.siemens.ad.pdraw.action.CopyAction;
import DE.siemens.ad.pdraw.action.InsertConnectionAction;
import DE.siemens.ad.pdraw.action.PasteAction;
import DE.siemens.ad.pdraw.app.LogoComfort;
import DE.siemens.ad.pdraw.figures.BlockFigure;
import DE.siemens.ad.pdraw.figures.FixedElbowConnection;
import DE.siemens.ad.pdraw.figures.InputIfcFigure;
import DE.siemens.ad.pdraw.figures.OutputIfcFigure;
import DE.siemens.ad.pdraw.standard.LogoDrawing;
import DE.siemens.ad.pdraw.standard.LogoDrawingView;
import DE.siemens.ad.udf.EditUDFFigure;
import DE.siemens.ad.udf.LogoDrawingUDF;
import DE.siemens.ad.udf.LogoDrawingViewUDF;
import DE.siemens.ad.udf.MutablePair;
import DE.siemens.ad.udf.Pair;
import DE.siemens.ad.udf.UDFEditorInfo;
import java.awt.Point;
import java.awt.Rectangle;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Vector;

public class CreateUDFAction
extends LogoAction {
    protected ProgramException fMessages;

    public CreateUDFAction() {
        this.putValue("Name", "create UDF");
        this.putValue("textKey", "pdraw.standard.createUDF");
        this.putValue("SmallIcon", Global.getIcon("CreateUDF.gif"));
        this.putValue("ShortDescription", Language.getStringNoTilde("pdraw.standard.createUDF", "create UDF"));
    }

    protected void addWarning(String text) {
        if (this.fMessages == null) {
            this.fMessages = new ProgramException();
        }
        this.fMessages.setLog(text);
    }

    public void displayMessages() {
        if (this.fMessages != null) {
            this.fMessages.display(((LogoComfort)this.getOwner()).getApplicationSurface().getWindow(), null);
        }
    }

    public void deleteMessages() {
        if (this.fMessages != null) {
            this.fMessages = null;
        }
    }

    public boolean prepareAction() {
        this.deleteMessages();
        return true;
    }

    public boolean doIt() {
        InsertConnectionAction insertConnectionAction;
        FixedElbowConnection fbc;
        int idx;
        Block anInsideOwner;
        Block actualInsideOwner;
        BlockConnector appendUDFConnector;
        List insideConnectors;
        LogoDrawingView originalView = (LogoDrawingView)((LogoComfort)this.getOwner()).view();
        LogoDrawing originalDrawing = (LogoDrawing)originalView.drawing();
        Vector originalSelectedFigures = originalView.selectionZOrdered();
        LogoComfort originalEditor = (LogoComfort)this.getOwner();
        ActionManager actionManager = originalEditor.getActionManager();
        CopyAction copyAction = new CopyAction();
        copyAction.setOwner(originalEditor);
        Application.getInstance().newDocument(new UDFEditorInfo());
        LogoDrawingViewUDF newView = (LogoDrawingViewUDF)Application.getInstance().getMdiManager().getActiveTopLevelView();
        LogoComfort newEditor = (LogoComfort)newView.getEditor();
        LogoDrawingUDF newDrawing = (LogoDrawingUDF)newView.drawing();
        EditUDFFigure editUDFFigure = newDrawing.getEditUDFFigure();
        Rectangle editRect = editUDFFigure.getEditArea();
        actionManager.invokeAction(copyAction);
        PasteAction pasteAction = new PasteAction();
        pasteAction.setOwner(newEditor);
        pasteAction.setPastePosition(new Point(editRect.x + 60, editRect.y + 20));
        if (!actionManager.invokeAction(pasteAction)) {
            return false;
        }
        HashMap<Block, Block> selectedBlockMap = new HashMap<Block, Block>();
        ArrayList newSelectedBlocks = pasteAction.getBlockFigures();
        Vector<BlockFigure> blockFigures = new Vector<BlockFigure>();
        int i = 0;
        int j = 0;
        while (i < originalSelectedFigures.size()) {
            while (i < originalSelectedFigures.size() && (!(originalSelectedFigures.get(i) instanceof BlockFigure) || originalSelectedFigures.get(i) instanceof EditUDFFigure.MiniBlockFigure)) {
                ++i;
            }
            if (i < originalSelectedFigures.size()) {
                selectedBlockMap.put(((BlockFigure)originalSelectedFigures.get(i)).getBlock(), ((BlockFigure)newSelectedBlocks.get(j)).getBlock());
                blockFigures.add((BlockFigure)originalSelectedFigures.get(i));
            }
            ++i;
            ++j;
        }
        HashSet connectionsInOriginalView = new HashSet();
        for (Figure anOriginalFigure : originalSelectedFigures) {
            if (!(anOriginalFigure instanceof FixedElbowConnection)) continue;
            FixedElbowConnection connection = (FixedElbowConnection)anOriginalFigure;
            Figure startFigure = connection.start().owner();
            Figure endFigure = connection.end().owner();
            if (!originalSelectedFigures.contains(startFigure.container()) || !originalSelectedFigures.contains(endFigure.container())) continue;
            MutablePair<OutBlockConnector, InBlockConnector> tmpPair = new MutablePair<OutBlockConnector, InBlockConnector>();
            if (startFigure instanceof OutputIfcFigure) {
                tmpPair.setFirst((OutBlockConnector)((OutputIfcFigure)startFigure).getBlockConnector());
            }
            if (endFigure instanceof InputIfcFigure) {
                tmpPair.setSecond((InBlockConnector)((InputIfcFigure)endFigure).getBlockConnector());
            }
            if (tmpPair.first() == null || tmpPair.second() == null) continue;
            connectionsInOriginalView.add(tmpPair);
        }
        HashMap<InBlockConnector, ArrayList<OutBlockConnector>> mapOfInConnectors = new HashMap<InBlockConnector, ArrayList<OutBlockConnector>>();
        HashMap<OutBlockConnector, ArrayList<InBlockConnector>> mapOfOutConnectors = new HashMap<OutBlockConnector, ArrayList<InBlockConnector>>();
        for (BlockFigure bf : blockFigures) {
            OutBlockConnector[] outConnectors;
            Block blk = bf.getBlock();
            InBlockConnector[] inConnectors = blk.getInConnectors();
            if (inConnectors != null) {
                for (InBlockConnector anInConnector : inConnectors) {
                    OutBlockConnector linkedConnector = anInConnector.getLinkedConnector();
                    if (linkedConnector == null) continue;
                    Block linkedConnectorOwner = null;
                    linkedConnectorOwner = linkedConnector.getOwner() instanceof DeputyBlock ? ((DeputyBlock)linkedConnector.getOwner()).getParent() : linkedConnector.getOwner();
                    if (connectionsInOriginalView.contains(new Pair<OutBlockConnector, InBlockConnector>(linkedConnector, anInConnector)) || blockFigures.contains(originalDrawing.getBlockFigure(linkedConnectorOwner))) continue;
                    ArrayList<InBlockConnector> list = (ArrayList<InBlockConnector>)mapOfOutConnectors.get(linkedConnector);
                    if (list == null) {
                        list = new ArrayList<InBlockConnector>();
                        mapOfOutConnectors.put(linkedConnector, list);
                    }
                    list.add(anInConnector);
                }
            }
            if ((outConnectors = blk.getOutConnectors()) == null) continue;
            for (OutBlockConnector anOutConnector : outConnectors) {
                InBlockConnectorEnumeration en = anOutConnector.getLinkedConnectors();
                while (en.hasMoreElements()) {
                    InBlockConnector linkedConnector = en.nextElement();
                    if (linkedConnector == null) continue;
                    Block linkedConnectorOwner = null;
                    linkedConnectorOwner = linkedConnector.getOwner() instanceof DeputyBlock ? ((DeputyBlock)linkedConnector.getOwner()).getParent() : linkedConnector.getOwner();
                    if (connectionsInOriginalView.contains(new Pair<OutBlockConnector, InBlockConnector>(anOutConnector, linkedConnector)) || blockFigures.contains(originalDrawing.getBlockFigure(linkedConnectorOwner))) continue;
                    ArrayList<OutBlockConnector> list = (ArrayList<OutBlockConnector>)mapOfInConnectors.get(linkedConnector);
                    if (list == null) {
                        list = new ArrayList<OutBlockConnector>();
                        mapOfInConnectors.put(linkedConnector, list);
                    }
                    list.add(anOutConnector);
                }
            }
        }
        int maxOutConnectorCount = newDrawing.getWiringDiagram().getHardware().getIntProperty("udfOutConnectorCount");
        int maxInConnectorCount = newDrawing.getWiringDiagram().getHardware().getIntProperty("udfInConnectorCount");
        int miniXLocation = editUDFFigure.getEditArea().x - editUDFFigure.getMiniFigureWidth() / 2;
        int miniLeftYlocation = editUDFFigure.getEditArea().y;
        int miniRightYlocation = editUDFFigure.getEditArea().y;
        EditUDFFigure.MiniBlockFigure mini = null;
        if (mapOfOutConnectors.size() <= maxInConnectorCount) {
            for (BlockConnector outSideConnector : mapOfOutConnectors.keySet()) {
                insideConnectors = (List)mapOfOutConnectors.get(outSideConnector);
                mini = editUDFFigure.addMiniBlockFigure(true, outSideConnector.getSignalType() == 1, new Point(miniXLocation, miniLeftYlocation += 30));
                appendUDFConnector = mini.getBlock().getOutConnector(0);
                for (BlockConnector anInsideConnector : insideConnectors) {
                    actualInsideOwner = null;
                    anInsideOwner = null;
                    if (anInsideConnector.getOwner() instanceof DeputyBlock) {
                        anInsideOwner = ((DeputyBlock)anInsideConnector.getOwner()).getParent();
                        actualInsideOwner = (Block)selectedBlockMap.get(anInsideOwner);
                    } else {
                        anInsideOwner = anInsideConnector.getOwner();
                        actualInsideOwner = (Block)selectedBlockMap.get(anInsideOwner);
                    }
                    InBlockConnector ibc = (InBlockConnector)anInsideConnector;
                    idx = anInsideOwner.getInConnectorPosition(ibc);
                    fbc = new FixedElbowConnection();
                    fbc.connectStart(mini.getOutputIfcFigure(appendUDFConnector).connectorAt(0, 0));
                    fbc.connectEnd(newDrawing.getBlockFigure(actualInsideOwner).getInputIfcFigure(actualInsideOwner.getInConnector(idx)).connectorAt(0, 0));
                    insertConnectionAction = (InsertConnectionAction)newEditor.getActionManager().getActionFactory().getAction("InsertConnectionAction");
                    insertConnectionAction.setConnectionFigure(fbc);
                    newEditor.getActionManager().invokeAction(insertConnectionAction);
                }
            }
        } else {
            this.addWarning(Language.getString("msg.maxUDFInConnectors", "Maximum number (" + maxInConnectorCount + ") of Input Connectors exceeded", maxInConnectorCount));
        }
        if (mapOfInConnectors.size() <= maxOutConnectorCount) {
            for (BlockConnector outSideConnector : mapOfInConnectors.keySet()) {
                insideConnectors = (List)mapOfInConnectors.get(outSideConnector);
                mini = editUDFFigure.addMiniBlockFigure(false, outSideConnector.getSignalType() == 1, new Point(miniXLocation + editUDFFigure.getEditArea().width, miniRightYlocation += 30));
                appendUDFConnector = mini.getBlock().getInConnector(0);
                for (BlockConnector anInsideConnector : insideConnectors) {
                    actualInsideOwner = null;
                    anInsideOwner = null;
                    if (anInsideConnector.getOwner() instanceof DeputyBlock) {
                        anInsideOwner = ((DeputyBlock)anInsideConnector.getOwner()).getParent();
                        actualInsideOwner = (Block)selectedBlockMap.get(anInsideOwner);
                    } else {
                        anInsideOwner = anInsideConnector.getOwner();
                        actualInsideOwner = (Block)selectedBlockMap.get(anInsideOwner);
                    }
                    OutBlockConnector obc = (OutBlockConnector)anInsideConnector;
                    idx = anInsideOwner.getOutConnectorPosition(obc);
                    fbc = new FixedElbowConnection();
                    fbc.connectStart(newDrawing.getBlockFigure(actualInsideOwner).getOutputIfcFigure(actualInsideOwner.getOutConnector(idx)).connectorAt(0, 0));
                    fbc.connectEnd(mini.getInputIfcFigure(appendUDFConnector).connectorAt(0, 0));
                    insertConnectionAction = (InsertConnectionAction)newEditor.getActionManager().getActionFactory().getAction("InsertConnectionAction");
                    insertConnectionAction.setConnectionFigure(fbc);
                    newEditor.getActionManager().invokeAction(insertConnectionAction);
                }
            }
        } else {
            this.addWarning(Language.getString("msg.maxUDFOutConnectors", "Maximum number (" + maxOutConnectorCount + ") of Output Connectors exceeded", maxOutConnectorCount));
        }
        newEditor.getActionManager().deleteRedoBuffer();
        newEditor.getActionManager().deleteUndoBuffer();
        newView.clearSelection();
        this.displayMessages();
        return true;
    }

    public void undoIt() {
    }
}

